@extends('layouts.master')
@section('page-name', __('lang.Contact Us'))

@section('content')

    <!-- Header Section -->
    <section class="header-bg">
        <div class="container-fluid p-100">
            <div class="header-contactus">
                <div class="overlay"></div>
                <div class="header-content">
                    <h1 class="header-title-contactus" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        {{ __('lang.header_title') }}</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="contact-section">


        <div class="container-fluid p-100">

            <div class="row">

                <!-- Contact Form -->
                <div class="col-md-6">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    <form action="{{ route('contact.send') }}" method="POST">
                        @csrf
                        <div class="form-group">
                            <label for="name" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                                {{ __('lang.your_name') }}
                            </label>
                            <input type="text" class="custom-input-contact" id="name" name="name" placeholder="{{ __('lang.full_name') }}" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                            @error('name')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="email" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                                {{ __('lang.your_email') }}
                            </label>
                            <input type="email" class="custom-input-contact" id="email" name="email" placeholder="{{ __('lang.email_address') }}" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                            @error('email')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="subject" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                                {{ __('lang.subject') }}
                            </label>
                            <input type="text" class="custom-input-contact" id="subject" name="subject" placeholder="{{ __('lang.subject') }}" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                            @error('subject')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="message" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                                {{ __('lang.message') }}
                            </label>
                            <textarea class="custom-input-contact" id="message" name="message" rows="5" placeholder="{{ __('lang.message') }}" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10"></textarea>
                            @error('message')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <button type="submit" class="custom-button-contact" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                            {{ __('lang.send_message') }}
                        </button>
                    </form>
                </div>
                <!-- Contact Information -->
                <div class="col-md-6 contact-info">
                    <h6 data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">{{ __('lang.contact_us') }}</h6>
                    <h2 data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">{{ __('lang.get_in_touch') }}</h2>
                    <p data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                        {{ __('lang.info_description') }}
                    </p>
                    <ul class="list-unstyled">
                        <li class="mb-3 mt-4 contact-item">
                            <img src="{{ asset('website/assets/images/contact-phone.svg') }}" alt="Call Icon" class="contact-icon" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                            <div class="contact-details" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                                <span class="contact-label-text">{{ __('lang.call_us') }}</span><br>
                                <span class="contact-info-det" dir="ltr">{{$contactInfo?->phone}}</span>
                            </div>
                        </li>
                        <li class="mb-3 mt-4 contact-item email-contact">
                            <img src="{{ asset('website/assets/images/message-contact.svg') }}" alt="Email Icon" class="contact-icon" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                            <div class="contact-details" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                                <span class="contact-label-text">{{ __('lang.email_us') }}</span><br>
                                <span class="contact-info-det">{{$contactInfo?->email}}</span>
                            </div>
                        </li>

                        <li class="mb-3 mt-4 contact-item">
                            <img src="{{ asset('website/assets/images/address-icon.svg') }}" alt="Address Icon" class="contact-icon" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                            <div class="contact-details" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                                <span class="contact-label-text">{{ __('lang.address') }}</span><br>
                                <span class="contact-info-det">{{ $contactInfo?->address }}</span>
                            </div>
                        </li>

                    </ul>
                    <div class="social-icons-contact mt-5">
                        <h6 class="follow-us-text mb-4" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                            {{ __('lang.follow_us') }}
                        </h6>
                        <!-- Social Icons -->
                        <a href="{{$contactInfo?->facebook}}" target="_blank">
                            <img src="{{ asset('website/assets/images/facebook icon.png') }}" alt="Facebook" data-aos="fade-up" data-aos-duration="500" data-aos-offset="10">
                        </a>
                        <a href="{{$contactInfo?->telegram}}" target="_blank">
                            <img src="{{ asset('website/assets/images/send icon.png') }}" alt="Telegram" data-aos="fade-up" data-aos-duration="600" data-aos-offset="10">
                        </a>
                        <a href="{{$contactInfo?->twitter}}" target="_blank">
                            <img src="{{ asset('website/assets/images/twitter icon.png') }}" alt="Twitter" data-aos="fade-up" data-aos-duration="700" data-aos-offset="10">
                        </a>
                        <a href="{{$contactInfo?->instegram}}" target="_blank">
                            <img src="{{ asset('website/assets/images/instagram icon.png') }}" alt="Instagram" data-aos="fade-up" data-aos-duration="800" data-aos-offset="10">
                        </a>
                        <a href="{{$contactInfo?->youtube}}" target="_blank">
                            <img src="{{ asset('website/assets/images/youtube icon.png') }}" alt="YouTube" data-aos="fade-up" data-aos-duration="900" data-aos-offset="10">
                        </a>
                        <a href="{{$contactInfo?->tiktok}}" target="_blank">
                            <img src="{{ asset('website/assets/images/music icon.png') }}" alt="TikTok" data-aos="fade-up" data-aos-duration="1000" data-aos-offset="10">
                        </a>
                    </div>
                </div>
            </div>
        </div>

    </section>

@endsection
