@extends('layouts.master')
@section('page-name', $book->slug)

@section('content')
    <!-- Header Section -->
    @include('website.productComponent.show.header-section',[
        'header_breadcrumb' => __("lang.Books"),
        'header_subtitle' => __("lang.book_header_subtitle"),
    ])



    <!-- compassionate-section -->
    @include('website.productComponent.show.product-sections',[
             'product' => $book,
             'type' => "books",
             'product_media_collection' => app()->getLocale() == 'ar' ? \App\Enums\Media\MediaCollection::BOOK_IMAGE_ARABIC->value : \App\Enums\Media\MediaCollection::BOOK_IMAGE_ENGLISH->value,
             'first_section_media_collection' => \App\Enums\Media\MediaCollection::BOOK_SECTION_ONE_IMAGE->value,
             'second_section_media_collection' => \App\Enums\Media\MediaCollection::BOOK_SECTION_TWO_IMAGE->value,
             'third_section_media_collection' => \App\Enums\Media\MediaCollection::BOOK_SECTION_THREE_IMAGE->value,
    ])



    <!-- interested-section -->
    @include('website.productComponent.show.interested-section',[
             'interested_products' => $interested_books,
             'interested_product_media_collection' => app()->getLocale() == 'ar' ? \App\Enums\Media\MediaCollection::BOOK_IMAGE_ARABIC->value : \App\Enums\Media\MediaCollection::BOOK_IMAGE_ENGLISH->value
      ])
@endsection


@push("scripts")
    <script type='text/javascript' src='https://platform-api.sharethis.com/js/sharethis.js#property=59ecdf1a95f7b200121c2a4d&product=inline-share-buttons' async='async'></script>
@endpush
