<?php

namespace App\Repositories\Interfaces;


use App\DTOs\AbstractDTO;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

interface EventRepositoryInterface
{
    public function getIsFeatured(AbstractDTO $dto): Collection;

    public function get(AbstractDTO $DTO);

    public function getBySlug(string $slug): ?Model;
    public function getInterestedEvents(AbstractDTO $dto, string $categoryId): Collection;

}

